<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-08-12 12:38
 */
interface NewdbnameDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Newdbname 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param newdbname primary key
 	 */
	public function delete($newdbnameid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Newdbname newdbname
 	 */
	public function insert($newdbname);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Newdbname newdbname
 	 */
	public function update($newdbname);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByDbname($value);


	public function deleteByDbname($value);


}
?>